package cn.com.duiba.oto.dto.oto.activity.apply;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动报名表
 *
 * @TableName tb_oto_activity_apply
 */
@Data
public class ActivityApplyDto implements Serializable {

    private static final long serialVersionUID = -7373895504695784498L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID，对应tb_oto_wx_users.id
     */
    private Long userId;

    /**
     * 活动ID，对应配置文件活动id
     */
    private Long activityId;

    /**
     * 新客户活动选取的奖品id，用逗号分开
     */
    private String prizeInfo;

    /**
     * 来源 0：自然流量 1：分享获取 2:管理后台添加
     */
    private Integer custSource;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 报名关联的专家id
     */
    private Long sellerId;

    /**
     * 状态：0:未删除 1:已删除
     */
    private Integer delStatus;

    /**
     * 扩展信息
     *
     * @see cn.com.duiba.oto.bean.activity.apply.ApplyExtraInfoBean
     */
    private String extInfo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

}