package cn.com.duiba.oto.dto.oto.pet;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2025/4/12 09:13
 * @Description:
 */
@Data
public class RemoteOrderDetailDto implements Serializable {
    private static final long serialVersionUID = -9032261481339078438L;
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 订单状态
     *
     * @see cn.com.duiba.oto.enums.pet.PetOrderStatusEnum
     */
    private Integer status;
    /**
     * 订单创建时间
     */
    private String createTime;
    /**
     * 支付时间
     */
    private String payTime;
    /**
     * 完成时间
     */
    private String finishTime;
    /**
     * 退款时间
     */
    private String refundTime;
    /**
     * 匹配时间
     */
    private String matchTime;
    // 地址信息
    /**
     * 地址ID
     */
    private Long addressId;
    /**
     * 地址名称
     */
    private String addressDetail;
    /**
     * 联系人
     */
    private String contactName;
    /**
     * 联系方式
     */
    private String contactPhone;
    /**
     * 订单总金额
     */
    private Long totalAmount;
    /**
     * 优惠金额
     */
    private Long discountAmount;
    /**
     * 实付金额
     */
    private Long payAmount;

    /**
     * 已退款金额
     */
    private Long refundAmount;

    // 服务项目
    private List<ServiceItemVO> serviceItems;

    @Data
    public static class ServiceItemVO implements Serializable {
        private static final long serialVersionUID = 140816508008132118L;
        /**
         * 服务日期
         */
        private String serviceDate;
        /**
         * 开门方式：1=密码锁，2=存放快递柜，3=家中有人，4=其他
         *
         * @see cn.com.duiba.oto.enums.pet.PetDoorTypeEnum
         */
        private Integer doorType;

        /**
         * 当天的宠物列表
         */
        List<PetItemVO> petItemVOS;

        /**
         * 服务时间段，如 "10:00-12:00"
         */
        private String timeRange;
        /**
         * 服务价格，单位为分
         */
        private Long price;
        /**
         * 加价金额（节假日和非常规时间加价）
         */
        private Long addPrice;

        /**
         * 是否节假日
         */
        private Boolean holiday;

        /**
         * 是否常规时间
         */
        private Boolean regularTime;
    }


    @Data
    public static class PetItemVO implements Serializable {
        private static final long serialVersionUID = 380533467017577129L;
        /**
         * 宠物ID
         */
        private Long petId;
        /**
         * 宠物名称
         */
        private String petName;
    }
}
