package cn.com.duiba.oto.dto.oto.pet;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 功能描述：OrderListItemVO类用于表示订单列表中的每一项信息。
 *
 * @Auther: xiaotian
 * @Date: 2025/4/12 09:12
 * @Description: 该类包含订单的基本信息，如订单ID、订单号、状态、创建时间、支付金额、宠物列表和服务时间列表。
 */
@Data
public class RemoteOrderListItemDto implements Serializable {
    private static final long serialVersionUID = 3899414444557489102L;
    /**
     * 订单ID，唯一标识一个订单
     */
    private Long orderId;
    /**
     * 订单号，用于展示和查询订单
     */
    private String orderNo;
    /**
     * 订单状态，表示订单的当前状态，如待服务、已完成等
     *
     * @see cn.com.duiba.oto.enums.pet.PetOrderStatusEnum
     */
    private Integer status;
    /**
     * 订单创建时间，表示订单创建的时间
     */
    private String createTime;
    /**
     * 订单支付金额，表示订单支付的总金额，单位为分
     */
    private Long payAmount;
    /**
     * 宠物列表，表示该订单中包含的宠物列表
     */
    private List<String> pets;
    /**
     * 服务时间列表，表示该订单中包含的服务时间列表
     */
    private List<Date> serviceTimes;
}
