package cn.com.duiba.oto.enums.pet;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 服务主订单状态
 * 订单状态：0=待支付，1=已支付，2=服务中，3=已完成，4=已取消
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum PetOrderStatusEnum {
    /**
     * 0=待支付
     */
    WAIT_PAY(0, "待支付"),

    /**
     * 1=已支付（待匹配）
     */
    PAY_SUCCESS(1, "待匹配"),

    /**
     * 2=待服务
     */
    SERVICE_ING(2, "待服务"),

    /**
     * 3=已完成
     */
    SERVICE_FINISH(3, "已完成"),
    /**
     * 4=退款中
     */
    SERVICE_REFUNDING(4, "退款中"),
    /**
     * 5=已退款
     */
    SERVICE_REFUND_FINISH(5, "已退款");

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PetOrderStatusEnum::getCode, PetOrderStatusEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }
}
