package cn.com.duiba.oto.enums.pet;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 服务子订单服务状态
 * 服务状态：0=待服务，1=已服务，2=用户取消，3=商家取消
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum PetSubOrderStatusEnum {
    /**
     * 待服务
     */
    WAIT_SERVICE(0, "待服务"),
    /**
     * 已服务
     */
    SERVICE_SUCCESS(1, "已服务"),
    /**
     * 用户取消
     */
    USER_CANCEL(2, "用户取消"),
    /**
     * 商家取消
     */
    SELLER_CANCEL(3, "商家取消"),
    ;
    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PetSubOrderStatusEnum::getCode, PetSubOrderStatusEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }
}
