package cn.com.duiba.oto.oto.service.api.remoteservice.pay;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.pay.RefundOrderDto;
import cn.com.duiba.oto.param.oto.pay.request.BaseRefundRequest;
import cn.com.duiba.oto.param.oto.pay.response.BaseRefundResponse;
import cn.com.duiba.oto.param.oto.pay.response.wxpay.WxPayRefundNotifyResponse;

/**
 * 退款相关
 *
 * @author xiaotian
 * @date 2024/8/8 2:15 PM
 */
@AdvancedFeignClient
public interface RemoteRefundService {

    /**
     * 微信退款异步接口
     * 返回成功只是提交成功
     *
     * @param refundRequest 退款请求
     * @return 微信退款请求响应
     * @throws BizException bizException
     */
    BaseRefundResponse refund(BaseRefundRequest refundRequest) throws BizException;

    /**
     * 通过商户退款单号查找退款订单流水
     *
     * @param outRefundNo 珊瑚退款单号
     * @return 退款流水
     */
    RefundOrderDto findByOutRefundNo(String outRefundNo) throws BizException;

    /**
     * 微信退款回调
     *
     * @param xmlData 退款回调信息
     * @return 退款回调结果
     */
    WxPayRefundNotifyResponse refundNotifyWx(String xmlData);

}
