/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.pet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum PetOrderStatusEnum {
    WAIT_PAY(0, "\u5f85\u652f\u4ed8"),
    PAY_SUCCESS(1, "\u5f85\u5339\u914d"),
    SERVICE_ING(2, "\u5f85\u670d\u52a1"),
    SERVICE_FINISH(3, "\u5df2\u5b8c\u6210"),
    SERVICE_REFUNDING(4, "\u9000\u6b3e\u4e2d"),
    SERVICE_REFUND_FINISH(5, "\u5df2\u9000\u6b3e");

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP;
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private PetOrderStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(PetOrderStatusEnum.values()).collect(Collectors.toMap(PetOrderStatusEnum::getCode, PetOrderStatusEnum::getDesc, (v1, v2) -> v1)));
    }
}

