/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.pet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum PetSpeciesEnum {
    DOG(1, "\u72d7"),
    CAT(2, "\u732b");

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP;
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public static PetSpeciesEnum getEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (PetSpeciesEnum petSpeciesEnum : PetSpeciesEnum.values()) {
            if (!petSpeciesEnum.getCode().equals(code)) continue;
            return petSpeciesEnum;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private PetSpeciesEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(PetSpeciesEnum.values()).collect(Collectors.toMap(PetSpeciesEnum::getCode, PetSpeciesEnum::getDesc, (v1, v2) -> v1)));
    }
}

