/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.pet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum PetSubOrderStatusEnum {
    WAIT_SERVICE(0, "\u5f85\u670d\u52a1"),
    SERVICE_SUCCESS(1, "\u5df2\u670d\u52a1"),
    USER_CANCEL(2, "\u7528\u6237\u53d6\u6d88"),
    SELLER_CANCEL(3, "\u5546\u5bb6\u53d6\u6d88");

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP;
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private PetSubOrderStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(PetSubOrderStatusEnum.values()).collect(Collectors.toMap(PetSubOrderStatusEnum::getCode, PetSubOrderStatusEnum::getDesc, (v1, v2) -> v1)));
    }
}

