package cn.com.duiba.oto.enums.system;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 系统配置枚举
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum SystemConfigEnum {
    /**
     * 新人活动配置
     */
    NEW_ACTIVITY_CONFIG("NEW_ACTIVITY_CONFIG", NewActivityConfigBean.class),

    /**
     * 新人活动奖品配置
     */
    NEW_ACTIVITY_PRIZE_CONFIG("NEW_ACTIVITY_PRIZE_CONFIG", NewActivityPrizeConfigBean.class),

    /**
     * 签到配置信息
     */
    SIGN_CONFIG("SIGN_CONFIG", SignConfigBean.class),

    /**
     * 分配黑名单配置
     */
    ASSIGN_BLACK_CONFIG("ASSIGN_BLACK_CONFIG", AssignBlackConfigBean.class);

    private static final Map<String, SystemConfigEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SystemConfigEnum::getKey, Function.identity(), (v1, v2) -> v1)));
    ;
    private final String key;
    private final Class<? extends SystemConfigBaseParamBean> beanClass;

    SystemConfigEnum(String key, Class<? extends SystemConfigBaseParamBean> beanClass) {
        this.key = key;
        this.beanClass = beanClass;
    }

    public static SystemConfigEnum getByKey(String key) {
        return INNER_MAP.getOrDefault(key, null);
    }

    public String getKey() {
        return key;
    }

    public Class<? extends SystemConfigBaseParamBean> getBeanClass() {
        return beanClass;
    }
}
