package cn.com.duiba.oto.enums.seller;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * OTO-成员角色类型
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum SellerRoleEnum {

    SYSTEM(1, 1, "系统管理员"),
    DIRECTOR(2, 4, "总监"),
    OFFICE_STAFF(3, 5, "内勤"),
    EXPERT(4, 6, "专家"),
    INVITE(5, 7, "邀约"),
    SELLER(6, 8, "销售"),
    AREA_DIRECTOR(7, 2, "区域总"),
    PM(8, 3, "PM"),
    SOLUTION(9, 9, "解决方案"),
    OPERATOR(10, 10, "运营"),
    SHANG_HAI(11, 11, "上海专用"),
    INVITE_SYSTEM(12, 12, "邀约管理员"),
    RISK(13, 13, "风控经理"),
    PROPERTY(14, 14, "物业专员"),
    ;

    private static final List<SellerRoleEnum> sellerRoleList = Collections.unmodifiableList(Arrays.asList(SYSTEM, DIRECTOR, OFFICE_STAFF, EXPERT, SELLER, AREA_DIRECTOR));

    private static final Map<Integer, String> TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SellerRoleEnum::getCode, SellerRoleEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private Integer order;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return TYPE_MAP.get(code);
    }

    public static SellerRoleEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return Stream.of(SellerRoleEnum.values()).filter(sellerRoleEnum -> sellerRoleEnum.getCode().equals(code)).findFirst().orElse(null);
    }

    /**
     * 是否销售
     *
     * @param roles
     * @return
     */
    public static boolean isSeller(List<Integer> roles) {
        return roles.stream().anyMatch(role ->
                sellerRoleList.stream().anyMatch(sellerRoleEnum -> sellerRoleEnum.getCode().equals(role)));
    }

    public static boolean showAllDealOrder(List<Integer> roles) {
        return roles.stream().anyMatch(role -> role.equals(SellerRoleEnum.RISK.getCode()) || role.equals(SellerRoleEnum.SYSTEM.getCode()));
    }


    public static boolean showPartDealOrder(List<Integer> roles) {
        return roles.stream().anyMatch(role -> role.equals(SellerRoleEnum.DIRECTOR.getCode()) || role.equals(SellerRoleEnum.AREA_DIRECTOR.getCode()));
    }
}
