package cn.com.duiba.oto.oto.service.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.CustTagCountDto;
import cn.com.duiba.oto.dto.oto.tag.CustomerTagDto;

import java.util.List;

/**
 * OTO-客户标签信息
 *
 * @author ZhangJun
 * @date 2022/1/10 5:13 下午
 */
@AdvancedFeignClient
public interface RemoteOtoCustTagService {

    /**
     * 根据标签id删除所有客户标签关联关系
     *
     * @param tagId 标签id
     * @return 删除条数
     */
    boolean deleteByTagId(Long tagId);

    /**
     * 根据标签id统计客户人数
     *
     * @param tagIds 标签id
     * @return 客户人数
     */
    List<CustTagCountDto> batchCountByTagId(List<Long> tagIds);

    /**
     * 批量新增
     * @param custId 客户id
     * @param tagIds 标签id列表
     * @return 新增结果
     */
    boolean batchInsert(Long custId, List<Long> tagIds);

    /**
     * 根据客户id列表获取关联列表
     * @param custIds 客户id
     * @return 关联列表
     */
    List<CustomerTagDto> listByCustIds(List<Long> custIds);

    /**
     * 根据标签id列表获取关联列表
     * @param tagIds 标签id
     * @return 关联列表
     */
    List<CustomerTagDto> listCustIdsByTagIds(List<Long> tagIds);

}
