package cn.com.duiba.oto.param.oto.pet.order;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：
 *
 *
 * @Auther: xiaotian
 * @Date: 2025/6/23 10:33
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteOrderCalculateWashParam extends RemoteOrderCalculateBaseParam {
    private static final long serialVersionUID = 1008790915759580553L;
    /**
     * 渠道ID
     */
    private Long channelId;
    /**
     * 宠物ID
     */
    @NotEmpty
    private List<ServiceItem> serviceItems;
    @Data
    public static class ServiceItem implements Serializable {

        private static final long serialVersionUID = -7654589233368725815L;
        /**
         * 宠物ID列表
         */
        @NotEmpty
        private List<ServiceSubItem> serviceSubItems;
        /**
         * 服务日期
         * yyyy-MM-dd
         */
        @NotNull
        private String serviceDate;

        /**
         * 服务时间段，如 "10:00-12:00"
         * HH:mm-HH:mm
         */
        private String timeRange;

        /**
         * 服务时间段：1=上午，2=下午，3=晚上
         * @see cn.com.duiba.oto.enums.pet.PetTimeSlotEnum
         */
        private Integer appointmentTimeSlot;

        /**
         * 开门方式：1=密码锁，2=存放快递柜，3=家中有人，4=其他
         * @see cn.com.duiba.oto.enums.pet.PetDoorTypeEnum
         */
        private Integer doorType;
    }

    @Data
    public static class ServiceSubItem implements Serializable {

        private static final long serialVersionUID = -4055188039695943416L;
        /**
         * 宠物ID列表
         */
        private Long petId;

        /**
         * 服务项目
         * @see cn.com.duiba.oto.enums.pet.PetWashTypeEnum
         * @see cn.com.duiba.oto.enums.pet.PetWashBaseEnum
         */
        private List<Integer> serviceItemId;
    }
}
