package cn.com.duiba.oto.enums.pet;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 宠物类别
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum PetSpeciesEnum {
    /**
     * 狗
     */
    DOG(1, "狗"),
    /**
     * 猫
     */
    CAT(2, "猫"),
    ;

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PetSpeciesEnum::getCode, PetSpeciesEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public static PetSpeciesEnum getEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (PetSpeciesEnum petSpeciesEnum : values()) {
            if (petSpeciesEnum.getCode().equals(code)) {
                return petSpeciesEnum;
            }
        }
        return null;
    }
}
