package cn.com.duiba.oto.oto.service.api.remoteservice.pay;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.param.oto.pay.request.wxpay.WxPayLiteChargeRequest;
import cn.com.duiba.oto.param.oto.pay.request.wxpay.WxPayLiteSignRequest;
import cn.com.duiba.oto.param.oto.pay.response.wxpay.WxPayChargeNotifyResponse;
import cn.com.duiba.oto.param.oto.pay.response.wxpay.WxPayLiteChargeResponse;

/**
 * 微信支付相关
 *
 * @author xiaotian
 * @date 2021/8/17 4:40 下午
 **/
@AdvancedFeignClient
public interface RemoteWxPaymentService {

    /**
     * 微信小程序收单接口
     *
     * @param chargeRequest 支付请求
     * @return WxPayLiteChargeResponse
     */
    WxPayLiteChargeResponse createWxPayLiteCharge(WxPayLiteChargeRequest chargeRequest) throws BizException;


    /**
     * 微信小程序生成签名信息
     *
     * @param chargeRequest 支付请求
     * @return WxPayLiteChargeResponse
     */
    WxPayLiteChargeResponse getWxPayLiteSignInfo(WxPayLiteSignRequest chargeRequest) throws BizException;


    /**
     * 微信支付回调
     *
     * @param xmlData 支付回调信息
     * @return 支付回调结果
     */
    WxPayChargeNotifyResponse orderNotifyWx(String xmlData);
}
