package cn.com.duiba.oto.enums.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2024-11-19 14:39
 * 与转介绍人关系
 */
@Getter
@AllArgsConstructor
public enum OtoCustIntroducerTypeEnum {

    /**
     * 配偶
     */
    SPOUSE(1, "配偶"),

    /**
     * 子女
     */
    CHILDREN(2, "子女"),

    /**
     * 父母
     */
    PARENT(3, "父母"),

    /**
     * 非直系亲属
     */
    NON_RELATIVE(4, "非直系亲属"),

    /**
     * 朋友
     */
    FRIEND(5, "朋友");


    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustIntroducerTypeEnum::getType, OtoCustIntroducerTypeEnum::getDesc, (v1, v2) -> v1)));
    private final Integer type;
    private final String desc;

    /**
     * 根据类型获取描述
     */
    public static String getDescByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ALL_MAP.get(type);
    }
}
