package cn.com.duiba.oto.enums.goods.order;

import lombok.Getter;

import java.util.Arrays;

/**
 * @Description
 * @Author huliangsheng
 * @Date 2024/8/15 11:00
 */
@Getter
public enum OrderReceiveTypeEnum {

    SELF(1, "客户自提"),
    SELLER(2, "销售代领");


    private Integer type;

    private String desc;

    OrderReceiveTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static OrderReceiveTypeEnum getByType(Integer type) {
        return Arrays.stream(OrderReceiveTypeEnum.values()).filter(item -> item.getType().equals(type)).findFirst().orElse(null);
    }
}
