package cn.com.duiba.oto.enums.activity;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 申请活动状态枚举
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum ActivityFlowEnum {

    NOT_START(1, "活动未开始"),
    START_NOT_SUBMIT(2, "活动开始，不能提交"),
    SUBMIT(3, "活动开始，可以提交"),
    SUBMIT_END(4, "活动开始，提交结束"),
    ACTIVITY_END(5, "活动结束");

    private static final Map<Integer, ActivityFlowEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ActivityFlowEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer code;
    private final String desc;

    ActivityFlowEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityFlowEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
