package cn.com.duiba.oto.oto.service.api.remoteservice.system;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.system.SystemConfigDto;
import cn.com.duiba.oto.enums.system.SystemConfigEnum;

import java.util.List;

/**
 * 系统配置接口
 *
 * @author xiaotian
 * @version 1.0
 * @date 2024-10-31 13:51
 */
@AdvancedFeignClient
public interface RemoteOtoSystemConfigService {

    /**
     * 获取系统配置
     *
     * @param systemConfigEnums
     * @return
     */
    List<SystemConfigDto> get(List<SystemConfigEnum> systemConfigEnums);

    /**
     * 新增或者更新配置
     *
     * @param systemConfigDto
     * @return
     */
    boolean updateOrInsert(SystemConfigDto systemConfigDto);
}
