package cn.com.duiba.oto.enums.deal;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 成单：与投保人关系
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum RelationForPolicyHolderEnum {

    MATE(1, "配偶"),
    CHILD(2, "子女"),
    PARENT(3, "父母"),
    COLLATERAL(4, "旁系亲属"),
    OTHER(4, "其他"),
    ;

    private static final Map<Integer, RelationForPolicyHolderEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(RelationForPolicyHolderEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer code;
    private final String desc;

    RelationForPolicyHolderEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static RelationForPolicyHolderEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
