package cn.com.duiba.oto.enums.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-06-29 13:52
 */
@AllArgsConstructor
@Getter
public enum PlanActionTypeEnum {

    PHONE("phone", "电话"),
    MEET("meet", "见面"),
    ;

    /**
     * 类型
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<String, PlanActionTypeEnum> INNER_MAP = Arrays.stream(values()).collect(Collectors.toMap(PlanActionTypeEnum::getCode, Function.identity(), (v1, v2) -> v1));

    public static PlanActionTypeEnum getByCode(String type) {
        return Objects.isNull(type) ? null : INNER_MAP.get(type);
    }
}
