package cn.com.duiba.oto.dto.oto.pet.order;

import cn.com.duiba.oto.dto.oto.pet.RemoteOrderCalculateResultDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：
 *
 *
 * @Auther: xiaotian
 * @Date: 2025/6/23 10:38
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteOrderCalculateResultFeedDto extends RemoteOrderCalculateResultBaseDto {
    private static final long serialVersionUID = -2361456689737841525L;
    /**
     * 服务项目价格列表
     */
    private List<RemoteOrderCalculateResultDto.ServiceItemPrice> itemPrices;

    @Data
    public static class ServiceItemPrice implements Serializable {
        private static final long serialVersionUID = -4254527997156798525L;
        /**
         * 当天的宠物列表
         */
        List<RemoteOrderCalculateResultDto.PetItemVO> petItemVOS;

        /**
         * 服务日期
         */
        private String serviceDate;

        /**
         * 开门方式：1=密码锁，2=存放快递柜，3=家中有人，4=其他
         *
         * @see cn.com.duiba.oto.enums.pet.PetDoorTypeEnum
         */
        private Integer doorType;

        /**
         * 服务时间段，如 "10:00-12:00"
         */
        private String timeRange;

        /**
         * 服务时间段：1=上午，2=下午，3=晚上
         * @see cn.com.duiba.oto.enums.pet.PetTimeSlotEnum
         */
        private Integer appointmentTimeSlot;

        /**
         * 当天的总服务价格，单位为分
         */
        private Long price;

        /**
         * 加价金额
         */
        private Long addPrice;

        /**
         * 是否节假日
         */
        private Boolean holiday;

        /**
         * 是否常规时间
         */
        private Boolean regularTime;

    }

    @Data
    public static class PetItemVO implements Serializable {
        private static final long serialVersionUID = 380533467017577129L;
        /**
         * 宠物ID
         */
        private Long petId;
        /**
         * 宠物名称
         */
        private String petName;
        /**
         * 服务价格，单位为分
         */
        private Long petPrice;

        /**
         * 洗护服务项目ID列表
         */
        private List<Integer> serviceItemIds;
    }
}
