package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * OTO-客户列表分页查询参数
 *
 * @author ZhangJun
 * @date 2022/1/5 7:38 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoCustPageListParam extends PageQuery {

    private static final long serialVersionUID = -210708968627650589L;

    /**
     * 客户手机号
     */
    private String phoneNum;

    /**
     * 客户价值
     */
    private List<Integer> custValueList;

    /**
     * 分配状态,0-待分配，1-已分配
     * {@link cn.com.duiba.oto.enums.cust.OtoCustAssignStatusEnum}
     */
    private Integer assignStatus;

    /**
     * 分配类型
     * @see cn.com.duiba.oto.enums.cust.follow.OtoCustAssignTypeEnum
     */
    private List<Integer> assignTypes;

    /**
     * 跟进状态
     */
    private List<Integer> followStatusList;

    /**
     * 当前跟进人id
     */
    private List<Long> otoSidList;

    /**
     * 搜索客户id
     */
    private List<Long> custIdList;

    /**
     * 起始分配时间
     */
    private Date assignBeginTime;

    /**
     * 结束分配时间
     */
    private Date assignEndTime;

    /**
     * 起始创建时间
     */
    private Date createBeginTime;

    /**
     * 结束创建时间
     */
    private Date createEndTime;

    /**
     * 客户所在省市区
     */
    private List<String> custAreas;

    /**
     * 客户所属保险公司id,tb_oto_company.id
     */
    private Long custCompany;

    /**
     * 所处资源池类型
     *
     * @see cn.com.duiba.oto.enums.cust.OtoCustPoolEnum
     */
    private List<Integer> poolTypes;

    /**
     * 流程组状态
     * @see cn.com.duiba.oto.enums.cust.CustFlowEnum
     */
    private Integer custFlow;

    /**
     * 客户来源
     * @see cn.com.duiba.oto.enums.cust.CustSourceEnum
     */
    private Integer custSource;
    /**
     * 客户名称
     */
    private String custName;

    /**
     * 客户来源
     * @see cn.com.duiba.oto.enums.cust.CustFromSourceEnum
     */
    private List<String> custFromSourceList;

    /**
     * 专家id
     */
    private Long expertSellerId;

    /**
     * 标签
     */
    private List<Long> tagIds;

    /**
     * 所属保险公司id
     */
    private Long companyId;

    /**
     * 所属保险公司id
     */
    private List<Long> companyIds;

    /**
     * 客户手机号归属地
     */
    private String custArea;

    private boolean flag;
}
