package cn.com.duiba.oto.param.oto.activity.apply;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @date 2023/9/06 13:40
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteSearchActivityParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 228087391805547407L;
    /**
     * 活动名称
     */
    private String activityTitle;

    /**
     * 活动状态：1-未开始，2-进行中，3-已结束
     */
    private List<Integer> activityStatus;

    /**
     * 活动类型 1:常规活动 2:新人活动
     *
     * @see cn.com.duiba.oto.enums.activity.ActivityTypeEnum
     */
    private Integer activityType;

    /**
     * 活动开始时间
     */
    private Date startTime;

    /**
     * 活动结束时间
     */
    private Date endTime;

}