package cn.com.duiba.oto.param.oto.pet.order;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：
 *
 *
 * @Auther: xiaotian
 * @Date: 2025/6/23 10:33
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteOrderCalculateFeedParam extends RemoteOrderCalculateBaseParam {
    private static final long serialVersionUID = -466286150446928953L;
    /**
     * 宠物ID
     */
    @NotEmpty
    private List<ServiceItem> serviceItems;

    @Data
    public static class ServiceItem implements Serializable {
        private static final long serialVersionUID = -5183084901099907701L;
        /**
         * 服务日期
         * yyyy-MM-dd
         */
        @NotNull
        private String serviceDate;

        /**
         * 服务时间段，如 "10:00-12:00"
         * HH:mm-HH:mm
         */
        private String timeRange;

        /**
         * 宠物ID列表
         */
        private List<Long> petIds;

        /**
         * 开门方式：1=密码锁，2=存放快递柜，3=家中有人，4=其他
         *
         * @see cn.com.duiba.oto.enums.pet.PetDoorTypeEnum
         */
        @NotNull
        private Integer doorType;
    }
}
