package cn.com.duiba.oto.dto.oto.wx;

import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * tb_oto_wx_users
 *
 * @author
 */
@Data
public class WxUsersDto implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 唯一ID，同一主体下唯一
     */
    private String unionId;

    /**
     * 备注
     */
    private Long remark;

    /**
     * 用户手机号
     */
    private String phoneNum;
    /**
     * 头像
     */
    private String headImg;
    /**
     * 昵称
     */
    private String nickName;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    private static final long serialVersionUID = 1L;

    public String convertNickName() {
        if (StringUtils.isNotEmpty(nickName)) {
            return nickName;
        }
        if (StringUtils.isNotEmpty(phoneNum)) {
            if (phoneNum.length() > 4) {
                return "用户昵称" + phoneNum.substring(phoneNum.length() - 4);
            } else {
                return "用户昵称" + phoneNum;
            }
        }
        return null;
    }

}