package cn.com.duiba.oto.enums.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-06-20 09:37
 */
@Getter
@AllArgsConstructor
public enum CustSourceExtEnum {

    OUT_FORM_IMPORT(301, CustSourceEnum.FORM, "表单客户-外部表单导入"),
    LAUNCH_FORM_IMPORT(302, CustSourceEnum.FORM, "表单客户-落地页表单生成"),
    SELF_BUILD_FORM_IMPORT(303, CustSourceEnum.FORM, "表单客户-自建站线索回传"),
    ;

    /**
     * code
     */
    private final Integer extCode;

    /**
     * code
     * @see CustSourceEnum
     */
    private final CustSourceEnum custSource;

    /**
     * 描述
     */
    private final String desc;
}
