package cn.com.duiba.oto.param.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author ZhangJun
 * @date 2022/2/16 16:52
 */
@Data
public class OtoCustCountParam implements Serializable {

    private static final long serialVersionUID = 1240613744379773727L;

    /**
     * 销售id
     */
    private Long otoSid;

    /**
     * 分配类型
     *
     * @see cn.com.duiba.oto.enums.cust.follow.OtoCustAssignTypeEnum
     */
    private List<Integer> assignTypes;

    /**
     * 分配起始时间
     */
    private Date assignBeginTime;

    /**
     * 分配结束时间
     */
    private Date assignEndTime;
}
