package cn.com.duiba.oto.dto.oto.pet;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class PetSchedulingItemDto implements Serializable {
    private static final long serialVersionUID = 8574437865746528267L;

    /**
     *  时间
     */
    private Date time;

    /**
     * 早班
     */
    private ListVO morning;
    /**
     * 中班
     */
    private ListVO noon;
    /**
     * 晚班
     */
    private ListVO evening;


    @Data
    public static class ListVO implements Serializable {
        private static final long serialVersionUID = -6665760673962409444L;
        /**
         * 排班
         */
        private List<PetSchedulingSubItemVO> schedulingSubItemVOS;

        // 剩余容量
        private Integer remainingCapacity;

        // 当前额外容量（为0定义为可添加额外容量，不为零则展示额外容量数量，可删除）
        private Integer extraCapacity;

        // 额外容量地址
        private List<String> address;
    }


    @Data
    public static class PetSchedulingSubItemVO implements Serializable {
        private static final long serialVersionUID = -1575918888732891790L;
        //是否线下订单 0:否 1:是
        private Integer offlineOrder;
        // 订单ID
        private Long orderId;
        /**
         * 订单状态
         *
         * @see cn.com.duiba.oto.enums.pet.PetOrderStatusEnum
         */
        private Integer status;
        // 服务地址
        private String serviceAddress;
        /**
         * 联系人姓名
         */
        private String contactName;
        /**
         * 联系电话
         */
        private String contactPhone;
        /**
         * 省份
         */
        private String addressProvince;
        /**
         * 市
         */
        private String addressCity;
        /**
         * 区
         */
        private String addressDistrict;
        /**
         * 详细地址
         */
        private String detailAddress;
        // 宠物信息
        private List<String> pets;
        // 订单金额
        private Long amount;
        // 匹配状态: 已匹配/未匹配
        private Integer matchStatus;
        /**
         * 宠托师ID
         */
        private Long staffId;
        //已经匹配的宠托师
        private String staffName;
        // 下单时间
        private String orderTime;
        /**
         * 安排上门时间
         */
        private Date appointmentTime;
        /**
         * 备注
         */
        private String orderRemark;
    }
}