package cn.com.duiba.oto.enums.interview;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author liuyajun
 */
@AllArgsConstructor
@Getter
public enum UnusualTypeEnum {
    /**
     * 面访客户扫码类型，1:扫描二维码2:长按图片识别二维码3：扫描手机相册中的二维码
     */
    NOT_FACE_TO_FACE(1, "非面对面扫码"),
    NOT_PHONE_OWN(2, "客户手机号非本人");
    private static final ImmutableMap<Integer, UnusualTypeEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, UnusualTypeEnum> builder = ImmutableMap.builder();
        for (UnusualTypeEnum item : UnusualTypeEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    private final Integer code;
    private final String desc;

    public static UnusualTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }
}
