package cn.com.duiba.oto.param.oto.pet;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2025/4/12 13:09
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemotePetOrderSearchParam extends PageQuery {
    private static final long serialVersionUID = 6426588203174174387L;
    /**
     * 客户姓名/手机号
     */
    private String keyword;
    /**
     * 订单状态
     * 1=待服务, 2=已完成
     */
    private Integer status;
    /**
     * 服务类型
     * @see cn.com.duiba.oto.enums.pet.PetServiceTypeEnum
     */
    private Integer serviceType;
    /**
     * 安排上门时间范围开始
     */
    private Date startTime;
    /**
     * 安排上门时间范围结束
     */
    private Date endTime;
    /**
     * 宠物昵称
     */
    private String petNickname;
    /**
     * 宠物专员id
     */
    private List<Long> staffIds;
    /**
     * 渠道id列表
     */
    private List<Long> channelIds;
}
