package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-10-09 16:55C
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OtoCustCheckListParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 6939120829236186248L;

    /**
     * 权限范围内的销售
     */
    private List<Long> allSellerIds;

    /**
     * 销售id
     */
    private List<Long> sellerIds;

    /**
     * 专家id
     */
    private List<Long> expertIds;

    /**
     * 专家id
     */
    private List<Long> inviteIds;

    /**
     * 客户名称
     */
    private String custName;
    /**
     * 客户手机号（可查备用手机号）
     */
    private List<String> custPhones;

    /**
     * 见面次数（开始）
     */
    private Integer meetTimesStart;

    /**
     * 见面次数（结束）
     */
    private Integer meetTimesEnd;

    /**
     * 盘点次数（开始）
     */
    private Integer checkTimesStart;

    /**
     * 盘点次数（结束）
     */
    private Integer checkTimesEnd;

    /**
     * 是否讲解计划书 1：是 0 ：否
     */
    private Integer explainPlanFlag;

    /**
     * 是否星标客户 1：是 0 ：否
     */
    private Integer custStar;

    /**
     * 是否高质量用户  1：是 0 ：否
     */
    private Integer inviteStar;

    /**
     * 是否社区高客  1：是 0 ：否
     */
    private Integer communityStar;

    /**
     * 最近一次见面时间（开始）
     */
    private Date lastMeetTimeStart;

    /**
     * 最近一次见面时间（结束）
     */
    private Date lastMeetTimeEnd;

    /**
     * 承接时间（开始）
     */
    private Date continueTimeStart;

    /**
     * 承接时间（结束）
     */
    private Date continueTimeEnd;

    /**
     * 最近一次联系时间
     */
    private Date lastFollowTimeStart;

    /**
     * 最近一次联系时间
     */
    private Date lastFollowTimeEnd;

    /**
     * 最近盘客户时间（开始）
     */
    private Date checkTimeStart;

    /**
     * 最近盘客户时间（结束）
     */
    private Date checkTimeEnd;

    /**
     * 可查看的销售id
     */
    private List<Long> mustInsellerIds;

    /**
     * 看查看的专家id
     */
    private List<Long> mustInexpertIds;

    /**
     * 重点跟进人
     */
    private List<Integer> followUps;

    /**
     * 客情维护活动参加情况
     */
    private List<Long> safeguardSceneConfIds;

    /**
     * 意向推荐活动参加情况
     */
    private List<Long> recommendSceneConfIds;

    /**
     * 是否可促单 0否 1是
     */
    private Integer promotionTypeFlag;

    /**
     * 是否已盘点  0:未盘点 1:已盘点
     */
    private Integer checkFlag;

    /**
     * 1：今天 2：一周 3：半月 4：一月
     */
    private Integer timeScope;

    /**
     * 是否放弃 0否 1是
     */
    private Integer hasGiveUpFlag;

    /**
     * 标签ID
     */
    private List<Long> tagIds;

    /**
     * 客户id
     */
    private List<Long> custIds;

    /**
     * 直播行为 1：已到场 2：已中奖 3：已填单
     */
    private List<Integer> liveAction;

    /**
     * 参与直播id列表
     */
    private List<String> liveIds;

    /**
            * 是否上传kyc 0否 1是
     */
    private Integer isUploadKyc;

    /**
     * 是否上传方案 0否 1是
     */
    private Integer isUploadPlan;

    /**
     * 是否上传风险评估报告 0否 1是
     */
    private Integer isUploadEvaluate;

    /**
     * 客户分类 1：未见面 2：已初次见面 3：已上传kyc 4：已上传风险评估报告 5：已上传方案 6：促单客户
     */
    private Integer custType;

    /**
     * 客户分类 1：未见面 2：已初次见面 3：已上传kyc 4：已上传风险评估报告 5：已上传方案 6：促单客户
     */
    private List<Integer> custTypes;

    /**
     * kyc合格状态 0未上传 1合格 2不合格 3已上传无状态
     */
    private List<Integer> kycStatus;

    /**
     * 是否总监来查询
     */
    private boolean director = false;

    /**
     * 是否全量查找
     */
    private boolean allSearch = false;

    /**
     * 是否标记成单 0否 1是
     */
    private Integer dealFlag;

    /**
     * 成单类别（1:正常单 2:孤儿单）
     * @see cn.com.duiba.oto.enums.deal.DealTypeEnum
     */
    private Integer dealType;

    /**
     * 成单专家id
     */
    private Long dealSellerId;

    /**
     * 是否14天内脱落 0否 1是
     */
    private Integer separateFlag;
    /**
     * 客户来源
     *
     * @see cn.com.duiba.oto.enums.cust.CustFromSourceEnum
     */
    private List<String> custFromSourceList;

    /**
     * 所属公司
     */
    private List<Long> companyIds;

    /**
     * 客户手机号归属地模糊查询
     */
    private String custArea;

    /**
     * 创建时间（开始）
     */
    private Date gmtCreateTimeStart;

    /**
     * 创建时间（结束）
     */
    private Date gmtCreateTimeEnd;

    /**
     * 账户ID集合
     */
    private List<String> launchAccountIds;


    /**
     * 所处资源池类型
     *
     * @see cn.com.duiba.oto.enums.cust.OtoCustPoolEnum
     */
    private List<Integer> poolTypes;

    /**
     * 广告组名称
     */
    private String adgroupName;

    /**
     * 加微状态
     */
    private Integer addWxStatus;

    /**
     * 是否约到一面 0否 1是
     */
    private Integer firstInterviewFlag;

    /**
     * 脱落是否需要邀约查阅
     * 0：不需要 1：需要
     */
    private Integer separateCheckRead;

    /**
     * 客户类型（小程序端搜索使用）
     * 1：转介绍 2：缘故客户 3：数字客户
     *
     * @see cn.com.duiba.oto.enums.cust.CustWxSearchTypeEnum
     */
    private List<Integer> custTypeSearch;

    /**
     * 是否有未领取的团单
     * 0：无 1：有
     */
    private Integer groupOrderFlag;

    /**
     * 是否有未领取的签到礼品
     * 0：无 1：有
     */
    private Integer signTaskFlag;
    /**
     * 是否团购优惠
     */
    private Integer preferential;
}
