/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.deal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DealStatusEnum {
    UNDERWRITE(1, "\u627f\u4fdd"),
    BOGGLE(2, "\u72b9\u9000"),
    FULL_REFUND(3, "\u5168\u989d\u9000\u4fdd"),
    LIMIT_PRICE_REFUND(4, "\u9650\u4ef7\u9000\u4fdd");

    private static final Map<Integer, DealStatusEnum> INNER_MAP;
    private final Integer code;
    private final String desc;

    private DealStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DealStatusEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        INNER_MAP = Collections.unmodifiableMap(Arrays.stream(DealStatusEnum.values()).collect(Collectors.toMap(DealStatusEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    }
}

