package cn.com.duiba.oto.dto.oto.invitation;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 功能描述：邀请函配置详情
 *
 * @Auther: xiaotian
 * @Date: 2023/3/14 10:13
 * @Description:
 */
@Data
public class OtoCustInvitationConfigDto implements Serializable {
    private static final long serialVersionUID = 1350341133385070149L;

    /**
     * 面访地点（见面场景配置ID）
     */
    private String interviewConfId;

    /**
     * 地址（上海/杭州）
     */
    private String address;

    /**
     * 客户面访承诺时间
     */
    private Date interviewTime;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 图片信息
     */
    private List<String> images;

    /**
     * 流程
     */
    private List<String> flows;

    /**
     * 内容
     */
    private List<String> contents;

    /**
     * 地址详情
     */
    private AddressDetail addressDetail;

    /**
     * 分享配置
     */
    private  ShareConfig shareConfig;

    /**
     * 展示时间
     */
    private String showTime;



    @Data
    public static class KeyValueDto implements Serializable {

        private static final long serialVersionUID = 3670007154126315794L;
        /**
         * key
         */
        private String key;

        /**
         * value
         */
        private String value;
    }


    @Data
    public static class AddressDetail implements Serializable {

        private static final long serialVersionUID = 3670007154126315794L;
        /**
         * 地址图片
         */
        private String addressImg;

        /**
         * 经度
         */
        private String longitude;

        /**
         * 纬度
         */
        private String latitude;

        /**
         * 详情
         */
        private String detail;
    }

    @Data
    public static class ShareConfig implements Serializable {

        private static final long serialVersionUID = 3670007154126315794L;
        /**
         * 分享图标
         */
        private String img;

        /**
         * 分享标题
         */
        private String title;

        /**
         * 分享描述
         */
        private String desc;
    }
}
