package cn.com.duiba.oto.oto.service.api.remoteservice.pet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.pet.staff.PetStaffDto;
import cn.com.duiba.oto.param.oto.pet.staff.PetStaffCreateParam;
import cn.com.duiba.oto.param.oto.pet.staff.PetStaffSearchParam;
import cn.com.duiba.oto.param.oto.pet.staff.PetStaffToggleStatusParam;
import cn.com.duiba.oto.param.oto.pet.staff.PetStaffUpdateParam;
import cn.com.duiba.oto.util.PageResult;

/**
 * 退款相关
 *
 * @author xiaotian
 * @date 2024/8/8 2:15 PM
 */
@AdvancedFeignClient
public interface RemotePetStaffService {

    /**
     * 搜索服务
     * @param param
     * @return
     */
    PageResult<PetStaffDto> searchStaff(PetStaffSearchParam param);

    /**
     * 创建服务
     * @param param
     * @return
     * @throws BizException
     */
    boolean createStaff(PetStaffCreateParam param) throws BizException;

    /**
     * 修改服务
     * @param param
     * @return
     * @throws BizException
     */
    boolean updateStaff(PetStaffUpdateParam param) throws BizException;

    /**
     * 删除服务
     * @param param
     * @return
     * @throws BizException
     */
    boolean toggleStaffStatus(PetStaffToggleStatusParam param) throws BizException;
}