package cn.com.duiba.oto.dto.oto.pet.order;

import lombok.Data;

import java.io.Serializable;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2025/4/12 09:13
 * @Description:
 */
@Data
public class RemoteOrderDetailBaseDto implements Serializable {
    private static final long serialVersionUID = -9032261481339078438L;
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 服务类型
     * @see cn.com.duiba.oto.enums.pet.PetServiceTypeEnum
     */
    private Integer serviceType;
    /**
     * 订单状态
     *
     * @see cn.com.duiba.oto.enums.pet.PetOrderStatusEnum
     */
    private Integer status;
    /**
     * 订单创建时间
     */
    private String createTime;
    /**
     * 支付时间
     */
    private String payTime;
    /**
     * 完成时间
     */
    private String finishTime;
    /**
     * 退款时间
     */
    private String refundTime;
    /**
     * 匹配时间
     */
    private String matchTime;
    // 地址信息
    /**
     * 地址ID
     */
    private Long addressId;
    /**
     * 省份
     */
    private String addressProvince;
    /**
     * 市
     */
    private String addressCity;
    /**
     * 区
     */
    private String addressDistrict;
    /**
     * 详细地址
     **/
    private String detailAddress;
    /**
     * 地址名称
     */
    private String addressDetail;
    /**
     * 联系人
     */
    private String contactName;
    /**
     * 联系方式
     */
    private String contactPhone;
    /**
     * 订单总金额
     */
    private Long totalAmount;
    /**
     * 优惠金额
     */
    private Long discountAmount;
    /**
     * 实付金额
     */
    private Long payAmount;

    /**
     * 已退款金额
     */
    private Long refundAmount;

    /**
     * 订单备注
     */
    private String orderRemark;

    /**
     * 渠道ID
     */
    private Long channelId;

    /**
     * 交通费（单位：分）
     */
    private Long trafficFee;
}
