package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 客户阶段流转表
 * @author kjj mybatis generator 
 * @date 2022-05-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CustPhaseExtSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16528533096986300L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 客户阶流程组名称 0: 客户待分配 1:具备机构养老理念 2:认同公司养老解决方案 3:认同你的保险方案 4.当下成交 5.已成单
     */
    private Byte custFlow;

    /**
     * 客户觉得退休后到底要准备多少退休金才够用
     */
    private Byte pensionSalary;

    /**
     * 希望退休后每个月的养老生活费是多少
     */
    private Byte pensionCost;

    /**
     * 除了退休养老规划，还希望了解的有关家庭财富的板块有哪些
     */
    private String pensionOther;

    /**
     * 是否提交养老计划方案 0:否 1：是
     */
    private Byte commitPlanFlag;

    /**
     * 计划书图片
     */
    private String planPicUrl;

    /**
     * 提交方案后客户状态 1近期有机会成交 2近期无法成交 3拒绝
     */
    private Byte commitCustStatus;

    /**
     * 客户是否已确认投保要素  0:否 1：是
     */
    private Byte commitInsure;

    /**
     * 客户未确认投保要素的原因
     */
    private String insureReason;

    /**
     * 产品ID tb_product
     */
    private Long productId;

    /**
     * 投保人 1自己 2配偶 3父母 4子女
     */
    private Byte insApplicant;

    /**
     * 被投保人 1自己 2配偶 3父母 4子女
     */
    private Byte insByApplicant;

    /**
     * 投保金额
     */
    private Integer insMoney;

    /**
     * 投保期数 0默认为趸交
     */
    private Integer insPeriod;

    /**
     * 是否成交 0:否 1:是
     */
    private Byte dealFlag;

    /**
     * 保单号
     */
    private String dealNumber;

    /**
     * 成单类别（1:正常单 2:孤儿单）
     */
    private Byte dealType;

    /**
     * 成单专家id
     */
    private Long dealSellerId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}