package cn.com.duiba.oto.enums.pet;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 功能描述：
 *
 *
 * @Auther: xiaotian
 * @Date: 2025/7/10 09:56
 * @Description:
 */
@Getter
@AllArgsConstructor
public enum PetTimeSlotEnum {
    MORNING(1, "09:00-12:00"),
    AFTERNOON(2, "12:00-18:00"),
    EVENING(3, "18:00-20:00");

    private final int value;

    private final String timeRange;

    //根据输入的timeRange 来输出是哪个时间段
    public static PetTimeSlotEnum getByTimeRange(String timeRange) {
        for (PetTimeSlotEnum value : PetTimeSlotEnum.values()) {
            if (value.timeRange.equals(timeRange)) {
                return value;
            }
        }
        return PetTimeSlotEnum.MORNING;
    }

    //根据value，找到具体的枚举
    public static PetTimeSlotEnum getByValue(int value) {
        for (PetTimeSlotEnum value1 : PetTimeSlotEnum.values()) {
            if (value1.value == value) {
                return value1;
            }
        }
        throw new IllegalArgumentException("Invalid value: " + value);
    }

    public int getValue() {
        return value;
    }
}
