package cn.com.duiba.oto.oto.service.api.remoteservice.interview;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.CustInterviewExtDto;
import cn.com.duiba.oto.dto.oto.interview.OtoCustInterviewExtDto;

import java.util.List;

/**
 * 描述：手机工作台1.0，客户面访
 *
 * @author liuyj
 * @date 2022-08-31
 */
@AdvancedFeignClient
public interface RemoteCustInterviewExtService {

    /**
     * 根据面访主键查询
     * @param interviewIds
     * @return
     */
    List<CustInterviewExtDto> selectByInterviewIds(List<Long> interviewIds);

    /**
     * 批量新增
     * @param dtos
     * @return
     */
    int batchImportInterviewRecordExt(List<OtoCustInterviewExtDto> dtos);

    /**
     * 根据客户ID分页查询面访记录
     * @param custId 客户ID
     * @return 返回部分面访字段信息
     */
    Long getCustInterviewRecordExtCountByCustId(Long custId);

    /**
     * 根据客户ID分页查询面访记录
     * @param custId 客户ID
     * @param offset 起始数据条数
     * @param limit 每页展示数据条数
     * @return 返回部分面访字段信息
     */
    List<OtoCustInterviewExtDto> getCustInterviewRecordExtPageByCustId(Long custId, Integer offset, Integer limit);
}
