package cn.com.duiba.oto.dto.oto.fission;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiaotian
 * @date 2023/9/06 13:45
 */
@Data
public class FissionCustDto implements Serializable {

    private static final long serialVersionUID = 1220085817764510885L;

    /**
     * 列表用户记录id
     */
    private Long recordId;
    /**
     * 可参与的总次数
     */
    private Integer allTimes;
    /**
     * 已参与次数
     */
    private Integer useTimes;

    /**
     * 有效分享数量
     */
    private Integer validShareCount;

    /**
     * 第一次参与时间
     */
    private String participateAt;

    /**
     * 手机号
     */
    private String phoneNum;

    /**
     * 客户姓名（若有）
     */
    private String custName;

    /**
     * 客户id（若有）
     */
    private Long custId;

    /**
     * 上级客户姓名（若有）
     */
    private String preCustName;

    /**
     * 上级客户id（若有）
     */
    private Long preCustId;

    /**
     * 上级客户跟进人（销售）（若有）
     */
    private String preSellerName;

    /**
     * 上级客户跟进人（邀约）（若有）
     */
    private String preInviteName;

    /**
     * 上级客户跟进人（专家）（若有）
     */
    private String preExportName;


    /**
     * 领奖时间
     */
    private String distributeAt;

    /**
     * 奖品
     */
    private List<RewardDto> rewardVoList;

    @Data
    public static class RewardDto implements Serializable {

        private static final long serialVersionUID = 324019335714299046L;

        /**
         * 奖品id
         */
        private Long rewardId;

        /**
         * 奖品名字
         */
        private String name;

        /**
         * 领取状态 0：未领取 1：已领取
         */
        private Integer rewardStatus = 0;

    }

}
