package cn.com.duiba.oto.dto.oto.pet.staff;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 渠道主表
 * @TableName tb_pet_channel
 */
@Data
public class PetChannelDto implements Serializable {
    private static final long serialVersionUID = -3156420337625937330L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 物业名称
     */
    private String propertyName;

    /**
     * 小区名称
     */
    private String communityName;

    /**
     * BD负责人
     */
    private String bdLeader;

    /**
     * 结算方式(1-物业结算,2-小区结算)
     */
    private Integer settlementMethod;

    /**
     * 渠道状态(0-已停用,1-已启用)
     */
    private Integer channelStatus;

    /**
     * 渠道码URL
     */
    private String channelCode;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}