package cn.com.duiba.oto.enums.cust.info;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 现金流情况枚举
 *
 * @author xiaotian
 * @date 2024-12-18
 */
@Getter
@AllArgsConstructor
public enum CashFlowEnum {

    /**
     * 50万以下
     */
    BELOW_50W(1, "50万以下"),

    /**
     * 50万-100万
     */
    BETWEEN_50W_100W(2, "50万-100万"),

    /**
     * 100万-200万
     */
    BETWEEN_100W_200W(3, "100万-200万"),

    /**
     * 200万以上
     */
    ABOVE_200W(4, "200万以上");

    /**
     * 编码
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据编码获取枚举
     *
     * @param code 编码
     * @return 枚举
     */
    public static CashFlowEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (CashFlowEnum item : values()) {
            if (item.getCode().equals(code)) {
                return item;
            }
        }
        return null;
    }

    /**
     * 根据编码获取描述
     *
     * @param code 编码
     * @return 描述
     */
    public static String getDescByCode(Integer code) {
        CashFlowEnum item = getByCode(code);
        return item != null ? item.getDesc() : null;
    }

    /**
     * 判断是否为高现金流（200万以上）
     *
     * @param code 编码
     * @return 是否为高现金流
     */
    public static boolean isHighCashFlow(Integer code) {
        return ABOVE_200W.getCode().equals(code);
    }

    /**
     * 判断是否为中高现金流（100万以上）
     *
     * @param code 编码
     * @return 是否为中高现金流
     */
    public static boolean isMediumHighCashFlow(Integer code) {
        return BETWEEN_100W_200W.getCode().equals(code) || ABOVE_200W.getCode().equals(code);
    }
}
