package cn.com.duiba.oto.dto.oto.amount;

import cn.com.duiba.oto.dto.oto.amount.enums.SourceFromEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 立减金记录
 *
 * @author songp
 * @date 2024/8/13 11:50 PM
 */
public class ExpireAmountRecordDto implements Serializable {

    private static final long serialVersionUID = 16540625622786853L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 初始立减金(单位分)
     */
    private Long initAmount;

    /**
     * 剩余立减金(单位分)
     */
    private Long remainAmount;

    /**
     * 扩展信息
     */
    private String extraJson;

    /**
     * 来源(1、观看视频获取 2、签到获取)
     * @see SourceFromEnum#getType()
     */
    private String amountSource;

    /**
     * 过期时间
     */
    private Date expireTime;

    /**
     * 过期状态:0:未过期,1:已过期 注：1：一定是过期，是0:有可能过期(特定场景下才会过期明细)
     */
    private String expireStatus;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Long getInitAmount() {
        return initAmount;
    }

    public void setInitAmount(Long initAmount) {
        this.initAmount = initAmount;
    }

    public Long getRemainAmount() {
        return remainAmount;
    }

    public void setRemainAmount(Long remainAmount) {
        this.remainAmount = remainAmount;
    }

    public String getExtraJson() {
        return extraJson;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    public String getAmountSource() {
        return amountSource;
    }

    public void setAmountSource(String amountSource) {
        this.amountSource = amountSource;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public String getExpireStatus() {
        return expireStatus;
    }

    public void setExpireStatus(String expireStatus) {
        this.expireStatus = expireStatus;
    }
}
