package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 看板查询参数
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardQueryParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 维度：team=团队数据, person=个人数据
     */
    private String dimension;

    /**
     * 团队ID（部门ID）
     * 个人指标时可选：传入时只查询该团队下的销售数据，不传时查询所有销售数据
     * 团队指标时不需要此参数
     */
    private Long teamId;

    /**
     * 月份，例如 2025-09 或 "7月"、"8月"、"9月"
     * 注意：除收入数据接口外，其他接口此字段为必填
     * 收入数据接口不需要此字段，会自动显示最新月份的数据
     */
    private String month;
}

