package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 表格数据DTO
 * 用于返回完整的表格数据（包含表头和行数据）
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardTableDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 表格列名列表
     * 第一列固定为"分组"，后续列为各个指标名称
     */
    private List<String> columns;

    /**
     * 表格行数据列表
     * 包含分组行和总计行
     */
    private List<BoardTableRowDto> rows;
}
