package cn.com.duiba.oto.enums.cust.log;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-06 17:57
 * 操作客户场景枚举
 */
@Getter
@AllArgsConstructor
public enum OtoCustOperationSceneEnum {

    INFO(1, "资料编辑"),
    VALUE(2, "客户价值更新"),
    TAG(3, "客户标签更新"),
    VISIT(4, "预约参观状态更新"),
    CALL(5, "打电话"),
    MEET(6, "面访"),
    FOLLOW_WEIGHT(7, "关注度更新"),
    CUST_DESCRIPTION(8, "客户备注"),
    EXPERT_REMARK(9, "专家评价"),
    COMMIT_PLAN_FLAG(10, "客户是否讲解计划书"),
    GROUPBUY_PREFERNENTIAL(11, "客户团购优惠开关"),
    ;

    /**
     * 场景值
     */
    private final Integer scene;

    /**
     * 描述
     */
    private final String desc;
}
