package cn.com.duiba.oto.enums.interview;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Objects;

/**
 * 面访类型
 *
 * @author xuanhongjian
 */
@Getter
public enum InterviewTypeEnum {
    /**
     * 1:普通面访 2:社区面访
     */
    ORDINARY_INTERVIEW("普通面访", 1),
    COMMUNITY_INTERVIEW("社区面访", 2);
    private static final ImmutableMap<Integer, InterviewTypeEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, InterviewTypeEnum> builder = ImmutableMap.builder();
        for (InterviewTypeEnum item : InterviewTypeEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    private final String desc;
    private final Integer code;

    InterviewTypeEnum(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    public static InterviewTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }
}
