package cn.com.duiba.oto.dto.oto.fission;

import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 功能描述：裂变活动客户信息/奖品配置/获奖列表
 *
 * @Auther: xiaotian
 * @Date: 2024/2/18 11:21
 * @Description:
 */
@Data
public class IndexDto implements Serializable {

    private static final long serialVersionUID = 1668967260840605984L;

    /**
     * 是否可参与
     */
    private boolean access = true;

    /**
     * 是否m1客户
     */
    private boolean m1 = false;

    /**
     * 是否第一次进入
     */
    private boolean firstIn = false;

    /**
     * 总次数
     */
    private Integer allTimes;

    /**
     * 已使用次数
     */
    private Integer useTimes;

    /**
     * 奖品配置
     */
    private List<RewardConfig> rewardConfigs;

    /**
     * 获奖列表
     */
    private List<RewardVo> rewardList = Collections.emptyList();

    /**
     * 分享配置
     */
    private ShareDto shareDto;


    @Data
    public static class RewardConfig implements Serializable {

        private static final long serialVersionUID = -7034709383066617880L;

        /**
         * 奖品id
         */
        private Long rewardId;

        /**
         * 奖品名称
         */
        private String name;

        /**
         * 奖品图标
         */
        private String icon;

        /**
         * 奖品类型 1：实物 2：微信红包 3:双人游
         */
        private Integer type;

    }


    @Data
    public static class RewardVo implements Serializable {

        private static final long serialVersionUID = 5478971635913749328L;

        /**
         * 奖品id
         */
        private Long rewardId;

        /**
         * 奖品名称
         */
        private String name;

        /**
         * 奖品图标
         */
        private String icon;

        /**
         * 中奖时间
         */
        private Date createDate;
        /**
         * 发放时间
         */
        private Date distributedAt;
    }


    @Data
    public static class ShareDto implements Serializable {


        private static final long serialVersionUID = 2069735391384232583L;

        /**
         * 分享url
         */
        private String url;

        /**
         * 图片
         */
        private String image;

        /**
         * 描述
         */
        private String desc;

        /**
         * 标题
         */
        private String title;

    }

}
