package cn.com.duiba.oto.oto.service.api.remoteservice.auth;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.auth.ApiMappingDto;
import cn.com.duiba.oto.dto.oto.auth.ApiPackageDto;

import java.util.List;
import java.util.Set;

/**
 * @author xiaotian
 * @description 接口权限
 * @date 2024/12/02 13:57
 */
@AdvancedFeignClient
public interface RemoteAuthService {

    /**
     * 新增更新系统接口
     *
     * @param apiMappingDto
     * @return
     */
    boolean ignoreSave(ApiMappingDto apiMappingDto);

    /**
     * 删除系统接口
     *
     * @param apiId
     * @return
     */
    boolean delApi(Long apiId);

    /**
     * 更新系统接口最后访问时间
     *
     * @param systemName
     * @param path
     * @return
     */
    boolean updateLastTime(String systemName, String path);

    /**
     * 根据系统名称，获取所有接口
     *
     * @param systemName
     * @return
     */
    List<ApiMappingDto> findAllApiBySystem(String systemName);

    /**
     * 新增/更新权限树
     *
     * @param apiPackageDto
     * @return
     */
    boolean addOrUpdateApiPackage(ApiPackageDto apiPackageDto);

    /**
     * 删除权限树
     *
     * @param packageId
     * @return
     */
    boolean delApiPackage(Long packageId) throws BizException;

    /**
     * 角色添加权限树
     *
     * @param roleId
     * @param packageIds
     * @return
     */
    boolean roleBindPackage(Integer roleId, List<Long> packageIds);

    /**
     * 角色删除权限树
     *
     * @param roleId
     * @param packageIds
     * @return
     */
    boolean roleUnBindPackage(Integer roleId, List<Long> packageIds);

    /**
     * 权限树添加接口
     *
     * @param packageId
     * @param apiIds
     * @return
     */
    boolean packageBindApi(Long packageId, List<Long> apiIds);

    /**
     * 权限树删除接口
     *
     * @param packageId
     * @param apiIds
     * @return
     */
    boolean packageUnBindApi(Long packageId, List<Long> apiIds);

    /**
     * 根据角色获取绑定的所有权限树
     */
    List<ApiPackageDto> apiPackageByRole(List<Integer> roles);

    /**
     * 获取所有权限树
     */
    List<ApiPackageDto> allApiPackage();

    /**
     * 根据权限树获取绑定的所有接口
     */
    List<ApiMappingDto> apiMappingByPackage(List<Long> packageIds);

    /**
     * 获取有权限的路径
     */
    Set<String> permissionPaths(Long sellerId, String systemName);

}
