package cn.com.duiba.oto.dto.oto.pet.channel;

import lombok.Data;

import java.io.Serializable;

@Data
public class PetChannelListItemDto implements Serializable {
    private static final long serialVersionUID = -8040560921868715987L;
    // 渠道ID
    private Long id;
    // 物业名称
    private String propertyName;
    // 小区名称
    private String communityName;
    // 创建时间
    private String gmtCreate;
    // 访问用户数
    private Integer visitUserCount;
    // 下单用户数
    private Integer orderUserCount;
    // 订单完成数
    private Integer completedOrderCount;
    // 渠道状态 (0-已停用, 1-已启用)
    private Integer channelStatus;
    // 结算方式 (1-物业结算, 2-小区结算)
    private Integer settlementMethod;
    // BD负责人
    private String bdLeader;
    /**
     * 额外字段（JSON格式）
     * @see cn.com.duiba.oto.bean.pet.PetChannelExtraParamBean
     */
    private String extraParam;
}